package com.biz.crm.business.common.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 懒加载树返回VO
 *
 * @author huxml
 */
@Getter
@Setter
public class LazyTreeVo implements Serializable {

    private static final long serialVersionUID = -2411866337210500375L;

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("编码")
    private String code;

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("类型编码")
    private String typeCode;

    @ApiModelProperty("类型名称")
    private String typeName;

    @ApiModelProperty("上级code")
    private String parentCode;

    @ApiModelProperty("是否有下级")
    private Boolean hasChild;

    @ApiModelProperty("是否有下级，1有 0无")
    private Integer hasChildFlag;

    @ApiModelProperty("对应SAP组织编码成本中心编码")
    private String costCenterCode;

    @ApiModelProperty("规则编码")
    private String ruleCode;

    @ApiModelProperty("下级")
    private List<LazyTreeVo> children;

}
