package com.biz.crm.business.common.sdk.vo;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * vo超类：包含了创建人、创建时间、修改人、修改时间
 *
 * @Author: hefan
 */
@Getter
@Setter
public abstract class UuidCrmOpVo extends UuidVo {
    private static final long serialVersionUID = 7946989319158425209L;

    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;

    @ApiModelProperty(name = "createDate", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;

    @ApiModelProperty(name = "updateAccount", value = "更新人账号")
    private String updateAccount;

    @ApiModelProperty(name = "updateDate", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;

    @ApiModelProperty(name = "updateName", value = "修改人名称")
    private String updateName;

    @ApiModelProperty("page优化问题")
    private String pageFlag = BooleanEnum.TRUE.getNumStr();


    public void setUpdateInfoToNull() {
        this.updateDate = null;
        this.updateAccount = null;
        this.updateName = null;
    }

    public void setCreateInfoNull() {
        this.createDate = null;
        this.createAccount = null;
        this.createName = null;
    }

    public void setAllInfoNull() {
        setCreateInfoNull();
        setUpdateInfoToNull();
    }

}
