package com.biz.crm.business.common.local.config;

import com.biz.crm.business.common.sdk.model.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author jerry7
 * @date 2021/11/4 9:45
 * 初步的全局异常捕获，后续完善
 */
@ControllerAdvice
@Slf4j
public class GlobalExceptionHandler {

  @ExceptionHandler(value = Exception.class)
  @ResponseBody
  public Result<?> errorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
    log.error("进入全局异常", e);
    return Result.error(e.getMessage());
  }
  @ExceptionHandler(value = HttpMessageNotReadableException.class)
  @ResponseBody
  public Result<?> httpMessageNotReadableExceptionHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
    log.error("进入全局异常（字段类型转换异常）", e);
    return Result.error("字段类型转换异常");
  }
}
