package com.biz.crm.business.common.local.deprecated.service;

import com.biz.crm.business.common.sdk.deprecated.vo.CrmBaseVo;
import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.List;

/**
 * 老版本VO属性赋值到新版本VO
 *
 * @author ning.zhang
 * @date 2021/10/11
 */
@Component
@Deprecated
public class CrmCopyOldVoToNewVoCallbackImpl implements CopyObjectCallback<CrmBaseVo, UuidOpVo> {

  @Override
  public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
    return CrmBaseVo.class.isAssignableFrom(sourceClass) && UuidOpVo.class.isAssignableFrom(targetClass);
  }

  @Override
  public void callback(Class<CrmBaseVo> sourceClass, List<CrmBaseVo> sourceObjects,
      Class<UuidOpVo> targetClass, List<UuidOpVo> targetObjects) {
    for (int i = 0; i < sourceObjects.size(); i++) {
      CrmBaseVo sourceObject = sourceObjects.get(i);
      UuidOpVo targetObject = targetObjects.get(i);

      if (UuidFlagOpVo.class.isAssignableFrom(targetClass)) {
        UuidFlagOpVo flagOpVo = (UuidFlagOpVo) targetObject;
        flagOpVo.setRemark(sourceObject.getRemarks());
      }
      targetObject.setCreateAccount(sourceObject.getCreateCode());
      targetObject.setModifyAccount(sourceObject.getUpdateCode());
      try {
        if (StringUtils.isNotBlank(sourceObject.getCreateDateAll())) {
          targetObject.setCreateTime(DateUtils.parseDate(sourceObject.getCreateDateAll(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (StringUtils.isNotBlank(sourceObject.getUpdateDateAll())) {
          targetObject.setModifyTime(DateUtils.parseDate(sourceObject.getUpdateDateAll(), "yyyy-MM-dd HH:mm:ss"));
        }
      } catch (ParseException e) {
        throw new IllegalArgumentException(e);
      }
    }
  }
}
