/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.config;

import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class RegistrarServerMsgHandler
extends KeyExpirationEventMessageListener
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RegistrarServerMsgHandler.class);
    @Value(value="${server.servlet.context-path:}")
    private String systemPath;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public RegistrarServerMsgHandler(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public void onMessage(Message message, byte[] pattern) {
        String key = message.toString();
        this.systemPath = this.systemPath.replace("/", "");
        if (key.equals("springboot-system-".concat(this.systemPath))) {
            log.info("\u8fc7\u671f\u76d1\u542c\u5411redis\u8fdb\u884c\u7cfb\u7edf\u6ce8\u518c-{}", (Object)key);
            this.redisTemplate.opsForValue().set((Object)key, (Object)this.systemPath, 1L, TimeUnit.HOURS);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.systemPath = this.systemPath.replace("/", "");
        String key = "springboot-system-" + this.systemPath;
        log.info("\u542f\u52a8\u5411redis\u8fdb\u884c\u7cfb\u7edf\u6ce8\u518c{}", (Object)key);
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.systemPath, 1L, TimeUnit.HOURS);
    }

    @DynamicTaskService(cornExpression="0 50/50 * * * ? ", taskDesc="\u7cfb\u7edf\u6ce8\u518c\u626b\u63cf\u5b9a\u65f6\u4efb\u52a1")
    public void scanCompensation() {
        this.systemPath = this.systemPath.replace("/", "");
        String key = "springboot-system-" + this.systemPath;
        log.info("\u5b9a\u65f6\u4efb\u52a1\u5411redis\u8fdb\u884c\u7cfb\u7edf\u6ce8\u518c-{}", (Object)key);
        this.redisTemplate.opsForValue().set((Object)key, (Object)this.systemPath, 1L, TimeUnit.HOURS);
    }
}

