package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 带品牌商租户编号基础实体类，通过code租户编号进行多租户的数据隔离
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class AppEntity extends TenantEntity {
  private static final long serialVersionUID = 3739789099248000982L;
  /**
   * 品牌商租户编号
   *
   */
  @ApiModelProperty(name = "appCode", value = "品牌商租户编号", required = true)
  @TableField(value = "app_code")
  @Column(name = "app_code", nullable = false, columnDefinition = "varchar(64)'")
  private String appCode;
}