package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 带租户编号基础实体类，通过code租户编号进行多租户的数据隔离(带创建人、修改人、创建时间、修改时间)
 * 启用、禁用、备注
 *
 * @Author: hefan
 * @Date: 2021/7/26 17:20
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class TenantFlagOpEntity extends UuidFlagOpEntity {


  private static final long serialVersionUID = -1920275602893554150L;

  @ApiModelProperty("租户编号")
  @TableField(value = "tenant_code")
  @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64)")
  private String tenantCode;

}
