package com.biz.crm.business.common.local.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 带工作流业务基础实体类,包含流程状态，流程编码等基础信息
 * 继承于TenantFlagOpEntity
 *
 * 从crm3.0 202208版本开始废弃该类的使用，业务数据中将不再包含工作流的数据，业务系统使用中间表进行工作流与业务数据的关联
 *
 * @author jerry7
 * @date: 2022/04/26
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class WorkflowFlagOpEntity extends TenantFlagOpEntity {


  private static final long serialVersionUID = -1920275602893554150L;


  /**
   * 审批流程编码
   */
  @ApiModelProperty("审批流程编码")
  @Column(name = "process_Key", columnDefinition = "VARCHAR(64)")
  private String processKey;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  @Column(name = "process_status", columnDefinition = "INT(2)")
  private String processStatus;

  /**
   * 审批单号
   */
  @ApiModelProperty("审批单号")
  @Column(name = "process_number", columnDefinition = "varchar(64)")
  private String processNumber;

  /**
   * 审批备注
   */
  @ApiModelProperty("审批备注")
  @Column(name = "process_remark", columnDefinition = "varchar(200)")
  private String processRemark;


}
