package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Comment;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * @author Administrator
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class FileEntity extends TenantEntity {
    private static final long serialVersionUID = 3739789099248000982L;

    /**
     * 文件唯一识别号
     */
    @Comment(value = "文件唯一识别号")
    @TableField(value = "file_code")
    @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64)")
    private String fileCode;

    /**
     * 原始文件名
     */
    @Comment("原始文件名")
    @TableField(value = "original_name")
    @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255)")
    private String originalFileName;
}