/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.config;

import com.biz.crm.business.common.sdk.model.Result;
import java.util.Arrays;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result<String> errorHandler(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error(e.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    public Result<String> httpMessageNotReadableExceptionHandler(HttpMessageNotReadableException e) {
        String errorMsg = "\u8bf7\u6c42\u7c7b\u578b\u5f02\u5e38:\u63a5\u53e3";
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = null;
            if (requestAttributes != null) {
                request = requestAttributes.getRequest();
            }
            if (Objects.nonNull(request)) {
                errorMsg = errorMsg + "[" + request.getRequestURI() + "]";
            }
            errorMsg = errorMsg + "\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef:" + e.getCause().getMessage();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        log.error(errorMsg, (Throwable)e);
        return Result.error(errorMsg);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Result<String> httpRequestMethodNotSupportedExceptionHandler(HttpRequestMethodNotSupportedException e) {
        String errorMsg = "\u8bf7\u6c42\u7c7b\u578b\u5f02\u5e38:\u63a5\u53e3";
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = null;
            if (requestAttributes != null) {
                request = requestAttributes.getRequest();
            }
            if (Objects.nonNull(request)) {
                errorMsg = errorMsg + "[" + request.getRequestURI() + "]";
            }
            errorMsg = errorMsg + "\u652f\u6301\u7c7b\u578b" + Arrays.toString(e.getSupportedMethods()) + ";\u5f53\u524d\u8bf7\u6c42\u7c7b\u578b[" + e.getMethod() + "]";
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        log.error(errorMsg, (Throwable)e);
        return Result.error(errorMsg);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    public Result<String> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException e) {
        String errorMsg = "\u8bf7\u6c42\u63a5\u53e3\u5f02\u5e38:\u63a5\u53e3";
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = null;
            if (requestAttributes != null) {
                request = requestAttributes.getRequest();
            }
            if (Objects.nonNull(request)) {
                errorMsg = errorMsg + "[" + request.getRequestURI() + "]";
            }
            errorMsg = errorMsg + "\u7f3a\u5931\u5fc5\u586b\u53c2\u6570;\u53c2\u6570\u7c7b\u578b[" + e.getParameterType() + "]\u53c2\u6570[" + e.getParameterName() + "]";
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        log.error(errorMsg, (Throwable)e);
        return Result.error(errorMsg);
    }
}

