/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class LogbackMdcFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LogbackMdcFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String traceId = httpServletRequest.getHeader("Trace_id");
            if (StringUtils.isNotBlank((CharSequence)traceId)) {
                MDC.put((String)"Trace_id", (String)traceId);
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            MDC.clear();
        }
    }
}

