package com.biz.crm.business.common.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * dto超类：包含了创建人、创建时间、修改人、修改时间
 *
 * @author sunx
 * @date 2021/10/18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class UuidOpDto extends UuidDto {

    private static final long serialVersionUID = 6676441040020869596L;

    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;

    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;

    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;

    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;


    public void setUpdateInfoToNull() {
        this.modifyTime = null;
        this.modifyAccount = null;
        this.modifyName = null;
    }

    public void setCreateInfoNull() {
        this.createTime = null;
        this.createAccount = null;
        this.createName = null;
    }

    public void setAllInfoNull() {
        setCreateInfoNull();
        setUpdateInfoToNull();
    }
}
