package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.Comment;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * 带租户编号基础实体类，通过code租户编号进行多租户的数据隔离(带创建人、修改人、创建时间、修改时间)
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public abstract class TenantOpEntity extends UuidOpEntity {

    private static final long serialVersionUID = -4536002767908839524L;

    /**
     * 租户编号
     */
    @Comment(value = "租户编号")
    @TableField(value = "tenant_code")
    @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64)")
    private String tenantCode;

}