package com.biz.crm.business.common.local.entity;
/**
 * Created by Bao Hongbin on 2021-09-27 17:25.
 */

import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * @program: crm
 * @description: 带启用、禁用、备注的树状结构基础实体类(带创建人、修改人、创建时间、修改时间)
 * @author: Bao Hongbin
 * @create: 2021-09-27 17:25
 **/
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class UuidFlagTreeOpEntity extends UuidFlagOpEntity {
  private static final long serialVersionUID = 6918500458873712485L;

  /**
   * 规则code 查询用
   */
  @TableField(value = "rule_code")
  @Column(name = "rule_code", nullable = false, length = 200, columnDefinition = "varchar(200)")
  private String ruleCode;

  /**
   * 层级等级 查询用
   */
  @TableField(value = "level_num")
  @Column(name = "level_num", length = 11, columnDefinition = "int(11)")
  private Integer levelNum;

}
