package com.biz.crm.business.common.local.service.internal;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.biz.crm.business.common.sdk.service.EmailService;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import java.util.Collection;
import java.util.Objects;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2023年12月18日 09:42:00
 */
@Service
@Slf4j
public class DefaultEmailServiceImpl implements EmailService {

  @Autowired(required = false)
  private JavaMailSender mailSender;

  @Autowired(required = false)
  private FileHandleService fileHandleService;

  @Value("${spring.mail.username:null}")
  private String defaultFrom;



  @Override
  public void sendMail(String from, String[] to, String[] cc, String subject, String content, Collection<FileDto> files) {
    try {
      //复杂邮件
      MimeMessage mimeMessage = mailSender.createMimeMessage();
      MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "utf-8");
      if (StringUtils.isBlank(from)){
        from=defaultFrom;
      }
      messageHelper.setFrom(from);
      messageHelper.setTo(to);
      String[] c = {};
      if (Objects.isNull(cc)) {
        messageHelper.setCc(c);
      } else {
        messageHelper.setCc(cc);
      }
      messageHelper.setSubject(subject);
      messageHelper.setText(content);
      if (!CollectionUtils.isEmpty(files)) {
        files.forEach(item -> {
          OrdinaryFileVo ordinaryFileVo = fileHandleService.findById(item.getFileCode());
          byte[] fileBytes = fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName());
          try {
            messageHelper.addAttachment(ordinaryFileVo.getOriginalFileName(), new ByteArrayResource(fileBytes));
          } catch (MessagingException e) {
            throw new RuntimeException(e);
          }
        });
      }
      mailSender.send(mimeMessage);
    } catch (MessagingException e) {
      log.error(e.getMessage(), e);
      throw new IllegalArgumentException("邮件发送错误，请检查邮件发送服务器配置", e);
    }
  }
}
