package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * @author hefan
 */
@Getter
@Setter
@MappedSuperclass
public class UuidEntity implements Serializable {

  private static final long serialVersionUID = -3660466424017680897L;

  @Id
  @GeneratedValue(generator = "uuid")
  @TableId(type = IdType.ASSIGN_UUID)
  @GenericGenerator(name = "uuid", strategy = "org.hibernate.id.UUIDGenerator")
  @Column(name = "id", length = 64, nullable = false, columnDefinition = "varchar(64)")
  private String id;

}
