package com.biz.crm.business.common.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * vo超类：包含了创建人、创建时间、修改人、修改时间
 *
 * @Author: hefan
 */
@Getter
@Setter
public abstract class UuidOpVo extends UuidVo {
    private static final long serialVersionUID = 7946989319158425209L;

    @ApiModelProperty(name = "createAccount", value = "创建人账号")
    private String createAccount;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(name = "createName", value = "创建人名称")
    private String createName;

    @ApiModelProperty(name = "modifyAccount", value = "更新人账号")
    private String modifyAccount;

    @ApiModelProperty(name = "modifyTime", value = "最后更新时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;

    @ApiModelProperty(name = "modifyName", value = "修改人名称")
    private String modifyName;


    public void setUpdateInfoToNull() {
        this.modifyTime = null;
        this.modifyAccount = null;
        this.modifyName = null;
    }

    public void setCreateInfoNull() {
        this.createTime = null;
        this.createAccount = null;
        this.createName = null;
    }

    public void setAllInfoNull() {
        setCreateInfoNull();
        setUpdateInfoToNull();
    }

}
