package com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 允销规则关联的(组织维度)终端或经销商信息(AllowSaleRuleDetail)实体类
 *
 * @author sunx
 * @since 2021-11-19 15:16:59
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_allow_sale_rule_detail")
@Table(
    name = "dms_allow_sale_rule_detail",
    indexes = {
      @Index(name = "dms_allow_sale_rule_detail1", columnList = "rule_code"),
      @Index(name = "dms_allow_sale_rule_detail2", columnList = "relate_code"),
    })
@ApiModel(value = "AllowSaleRuleDetail", description = "允销规则关联的(组织维度)终端或经销商信息")
@org.hibernate.annotations.Table(
    appliesTo = "dms_allow_sale_rule_detail",
    comment = "允销规则关联的(组织维度)终端或经销商信息")
public class AllowSaleRuleDetail extends TenantEntity {

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  @TableField(value = "rule_code")
  @Column(name = "rule_code", length = 64, columnDefinition = "varchar(64) COMMENT '允销规则编码'")
  private String ruleCode;

  /** 组织编码、终端编码、客户编码 */
  @ApiModelProperty("组织编码、终端编码、客户编码")
  @TableField(value = "relate_code")
  @Column(
      name = "relate_code",
      length = 64,
      columnDefinition = "varchar(64) COMMENT '组织编码、终端编码、客户编码'")
  private String relateCode;

  /** 组织名称、终端名称、客户名称 */
  @ApiModelProperty("组织名称、终端名称、客户名称")
  @TableField(exist = false)
  @Transient
  private String relateName;
}
