package com.biz.crm.dms.business.allow.sale.local.dimension.detail.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 允销规则关联的(组织维度)终端或经销商信息(AllowSaleRuleDetail)表数据库访问层
 *
 * @author sunx
 * @date 2021-11-19 15:17:00
 */
public interface AllowSaleRuleDetailMapper extends BaseMapper<AllowSaleRuleDetail> {

  /**
   * 获取关联的规则信息
   *
   * @param dimensionType 维度类型
   * @param relateCodeList 关联业务编码集合
   * @param tenantCode 租户
   * @param enableStatus 启禁用状态
   * @param delFlag 删除标记
   * @return
   */
  List<DetailRelateVo> findByDimensionTypeAndRelateCodes(
      @Param("dimensionType") String dimensionType,
      @Param("list") List<String> relateCodeList,
      @Param("tenantCode") String tenantCode,
      @Param("enableStatus") String enableStatus,
      @Param("delFlag") String delFlag);
}
