package com.biz.crm.dms.business.allow.sale.local.dimension.detail.service;

import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import java.util.List;

/**
 * 允销规则关联的(组织维度)终端或经销商信息(AllowSaleRuleDetail)表服务接口
 *
 * @author sunx
 * @date 2021-11-19 15:17:00
 */
public interface AllowSaleRuleDetailService {

  /**
   * 根据规则编码获取关联集合信息
   *
   * @param ruleCodeList 规则编码集合
   * @return
   */
  List<AllowSaleRuleDetail> findByRuleCodes(List<String> ruleCodeList);

  /**
   * 批量保存关联信息
   *
   * @param list 关联信息
   */
  void batchSave(List<AllowSaleRuleDetail> list);

  /**
   * 根据维度编码+关联编码获取关联关系
   *
   * @param dimensionType 维度类型
   * @param relateCodeList 关联编码集合
   * @return
   */
  List<DetailRelateVo> findByDimensionTypeAndRelateCodes(
      String dimensionType, List<String> relateCodeList);
}
