package com.biz.crm.dms.business.allow.sale.local.dimension.detail.service.internal;

import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.repository.AllowSaleRuleDetailRepository;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.service.AllowSaleRuleDetailService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 允销规则关联的(组织维度)终端或经销商信息(AllowSaleRuleDetail)表服务实现类
 *
 * @author sunx
 * @date 2021-11-19 15:17:00
 */
@Slf4j
@Service("allowSaleRuleDetailService")
public class AllowSaleRuleDetailServiceImpl implements AllowSaleRuleDetailService {

  @Autowired(required = false) private AllowSaleRuleDetailRepository allowSaleRuleDetailRepository;

  @Override
  @Transactional
  public List<AllowSaleRuleDetail> findByRuleCodes(List<String> ruleCodeList) {
    if (CollectionUtils.isEmpty(ruleCodeList)) {
      return Lists.newLinkedList();
    }
    return this.allowSaleRuleDetailRepository.findByRuleCodes(ruleCodeList);
  }

  @Override
  @Transactional
  public void batchSave(List<AllowSaleRuleDetail> list) {
    Validate.isTrue(CollectionUtils.isNotEmpty(list), "参数不能为空");
    String ruleCode = list.get(0).getRuleCode();
    Validate.notBlank(ruleCode, "规则编码不能为空");
    Optional<AllowSaleRuleDetail> first =
        list.stream().filter(a -> !ruleCode.equals(a.getRuleCode())).findFirst();
    Validate.isTrue(!first.isPresent(), "当前处理的集合必须属于同一个规则");
    Set<String> set = Sets.newHashSet();
    list.forEach(
        a -> {
          Validate.isTrue(set.add(a.getRelateCode()), "存在相同的终端、客户或组织信息");
          a.setTenantCode(TenantUtils.getTenantCode());
        });
    this.allowSaleRuleDetailRepository.deleteByRuleCode(ruleCode);
    this.allowSaleRuleDetailRepository.saveBatch(list);
  }

  @Override
  public List<DetailRelateVo> findByDimensionTypeAndRelateCodes(
      String dimensionType, List<String> relateCodeList) {
    if (StringUtils.isBlank(dimensionType) || CollectionUtils.isEmpty(relateCodeList)) {
      return Lists.newLinkedList();
    }
    return this.allowSaleRuleDetailRepository.findByDimensionTypeAndRelateCodes(
        dimensionType, relateCodeList);
  }
}
