package com.biz.crm.dms.business.allow.sale.local.dimension.service;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.DimensionDictVo;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 允销规则维度基座
 *
 * @author sunx
 * @date 2021/11/23
 */
public interface DimensionService {

  /**
   * 获取系统可用的维度注册信息 -- 用于前端界面下拉显示
   *
   * @return
   */
  List<DimensionDictVo> findDimensionDictVoList();

  /**
   * 获取维度对应的可购清单的业务类型
   *
   * @param dimensionType 维度类型
   * @return
   */
  String getListType(String dimensionType);

  /**
   * 保存维度配置明细信息
   *
   * @param data 维度配置json
   * @param dimensionType 维度类型
   */
  void saveDimension(JSONObject data, String dimensionType);

  /**
   * 根据允销规则编码获取维度详细配置信息
   *
   * @param ruleCode 规则编码
   * @param dimensionType 维度类型
   * @return
   */
  JSONObject findByRuleCode(String ruleCode, String dimensionType);

  /**
   * 根据维度关联编码获取对应的规则编码集合，维度变化调用
   *
   * @param relateCodeList 关联业务编码
   * @param dimensionType 维度类型
   * @return k-relateCode , v-ruleCode集合
   */
  Map<String, Set<String>> findRelateRuleCodesMapByRelateCodes(
      List<String> relateCodeList, String dimensionType);

  /**
   * 根据允销规则获取关联业务明细，是生成可购清单的数据基础
   *
   * @param ruleCodeList 关联业务编码
   * @param dimensionType 维度类型
   * @return k-ruleCode,v-可购清单纬度的businessCode集合（如终端编码、客户编码）
   */
  Map<String, Set<String>> findRuleRelateBusinessCodesMapByRuleCodes(
      List<String> ruleCodeList, String dimensionType);
}
