package com.biz.crm.dms.business.allow.sale.local.element.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.allow.sale.local.element.entity.AllowSaleElement;
import com.biz.crm.dms.business.allow.sale.local.element.mapper.AllowSaleElementMpper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * @description: 要素 允销清单信息(repository)
 * @author: rentao
 * @date: 2021/11/25 10:23
 */
@Component
public class AllowSaleElementRepository
    extends ServiceImpl<AllowSaleElementMpper, AllowSaleElement> {

  /**
   * 合同编码查询 要素 允销清单信息
   *
   * @param contractcode 合同编码
   */
  public List<AllowSaleElement> findByContractCode(String contractcode) {
    return this.lambdaQuery()
        .eq(AllowSaleElement::getContractcode, contractcode)
        .eq(AllowSaleElement::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }

  /**
   * 合同编码集合查询 要素 允销清单信息
   *
   * @param contractCodeList 合同编码集合
   */
  public List<AllowSaleElement> findByContractCodeList(List<String> contractCodeList) {
    return this.lambdaQuery()
        .in(AllowSaleElement::getContractcode, contractCodeList)
        .eq(AllowSaleElement::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }

  /**
   * 通过合同编码删除可购
   *
   * @param contractCode 合同编码
   */
  public void deleteByContractCode(String contractCode) {
    this.lambdaUpdate()
        .eq(AllowSaleElement::getContractcode, contractCode)
        .remove();
  }
}
