package com.biz.crm.dms.business.allow.sale.local.element.service;

import com.biz.crm.dms.business.allow.sale.local.element.entity.AllowSaleElement;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;

import java.util.List;

/**
 * @description: some desc
 * @author: rentao
 * @date: 2021/11/25 10:24
 */
public interface AllowSaleElementService {

  /**
   * 合同编码查询合同内容
   *
   * @param contractCode 合同编码
   * @return
   */
  AllowSaleElementDataVo findByContractCode(String contractCode);

  /**
   * 合同编码集合查询 要素 允销清单信息
   *
   * @param contractCodeList 合同编码集合
   * @return
   */
  List<AllowSaleElement> findByContractCodeList(List<String> contractCodeList);

  /**
   * 要素内容新增
   *
   * @param contractCode 合同编码
   * @param allowSaleElementDataVo 要素
   * @param indexCode 索引号
   * @return
   */
  AllowSaleElementDataVo createAllowSaleElement(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode);

  /**
   * 要素内容修改
   *
   * @param contractCode 合同编码
   * @param allowSaleElementDataVo 要素
   * @param indexCode 索引号
   * @return
   */
  AllowSaleElementDataVo updateAllowSaleElement(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode);
}
