package com.biz.crm.dms.business.allow.sale.local.list.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 允销清单信息: AllowSaleList: 允销清单信息
 *
 * @author sunx
 * @date 2021-11-19 15:15:43
 */
@Slf4j
@Api(tags = "允销清单信息: AllowSaleList: 允销清单信息")
@RestController
@RequestMapping(value = {"/v1/allowSaleList/allowSaleList"})
public class AllowSaleListController {

  @Autowired(required = false)
  private AllowSaleListService allowSaleListService;

  /**
   * 逻辑删除
   *
   * @param ids 主键集合
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestParam("ids") List<String> ids) {
    try {
      this.allowSaleListService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
