package com.biz.crm.dms.business.allow.sale.local.list.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListDmsPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListDmsVoService;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListDmsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 允销清单信息: AllowSaleListDmsVo: 允销清单信息-电商接口
 *
 * @author sunx
 * @date 2021/12/6
 */
@Slf4j
@Api(tags = "允销清单信息: AllowSaleListDmsVo: 允销清单信息-电商接口")
@RestController
@RequestMapping(value = {"/v1/allowSaleList/allowSaleListDms"})
public class AllowSaleListDmsVoController {
  @Autowired(required = false)
  private AllowSaleListDmsVoService allowSaleListDmsVoService;

  /**
   * 查询分页列表
   *
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<AllowSaleListDmsVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, AllowSaleListDmsPaginationDto dto) {
    try {
      Page<AllowSaleListDmsVo> result =
          this.allowSaleListDmsVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
