package com.biz.crm.dms.business.allow.sale.local.list.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 允销清单信息(AllowSaleList)实体类
 *
 * <p>可购清单是确定人货关系的唯一凭证
 *
 * <p>主要属性businessCode+listType+productCode
 *
 * <p>productCode确定货
 *
 * <p>businessCode+listType确定人
 *
 * <p>businessCode 根据业务不同可以是终端、客户、用户等
 *
 * <p>listType 为业务区分，和businessCode业务匹配
 *
 * @author sunx
 * @since 2021-11-19 15:15:40
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_allow_sale_list")
@Table(
    name = "dms_allow_sale_list",
    indexes = {
      @Index(name = "das_idx1", columnList = "tenant_code,item_key", unique = true),
      @Index(name = "das_idx2", columnList = "list_type"),
      @Index(name = "das_idx3", columnList = "business_code"),
      @Index(name = "das_idx4", columnList = "product_code"),
    })
@ApiModel(value = "AllowSaleList", description = "允销清单信息")
@org.hibernate.annotations.Table(appliesTo = "dms_allow_sale_list", comment = "允销清单信息")
public class AllowSaleList extends UuidEntity {

  /** 允销清单类型，终端或客户 */
  @ApiModelProperty("允销清单类型")
  @TableField(value = "list_type")
  @Column(name = "list_type", length = 36, columnDefinition = "varchar(36) COMMENT '允销清单类型'")
  private String listType;

  /** 业务编码，终端编码或客户编码 */
  @ApiModelProperty("业务编码，终端编码或客户编码")
  @TableField(value = "business_code")
  @Column(
      name = "business_code",
      length = 64,
      columnDefinition = "varchar(64) COMMENT '业务编码，终端编码或客户编码'")
  private String businessCode;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '商品编码'")
  private String productCode;

  /** 可购规则关联数量 */
  @ApiModelProperty("可购规则关联数量")
  @TableField(value = "allow")
  @Column(name = "allow", columnDefinition = "int default 0 not null COMMENT '可购规则关联数量'")
  private Integer allow;

  /** 不可购规则关联数量 */
  @ApiModelProperty("不可购规则关联数量")
  @TableField(value = "not_allow")
  @Column(name = "not_allow", columnDefinition = "int default 0 not null COMMENT '不可购规则关联数量'")
  private Integer notAllow;

  /** 行记录唯一码 */
  @ApiModelProperty("行记录唯一码，list_type+business_code+product_code")
  @TableField(value = "item_key")
  @Column(name = "item_key", length = 150, columnDefinition = "varchar(150) COMMENT '行记录唯一码'")
  private String itemKey;

  /** 租户编号 */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  @TableField(value = "tenant_code")
  @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT '租户编号'")
  private String tenantCode;

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AllowSaleList that = (AllowSaleList) o;
    return Objects.equals(itemKey, that.itemKey) && Objects.equals(tenantCode, that.tenantCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemKey, tenantCode);
  }
}
