package com.biz.crm.dms.business.allow.sale.local.list.model;

import java.util.Objects;
import lombok.Data;

/**
 * 关联数据规则信息
 *
 * @author sunx
 * @date 2022/6/24
 */
@Data
public class RelateRule {

  /** 规则编码 */
  private String ruleCode;
  /** 规则类型 */
  private String ruleType;
  /** 清单类型 */
  private String listType;

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelateRule that = (RelateRule) o;
    return Objects.equals(ruleCode, that.ruleCode)
        && Objects.equals(ruleType, that.ruleType)
        && Objects.equals(listType, that.listType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ruleCode, ruleType, listType);
  }
}
