package com.biz.crm.dms.business.allow.sale.local.list.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.allow.sale.local.list.entity.AllowSaleList;
import com.biz.crm.dms.business.allow.sale.local.list.model.RelateRule;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 允销清单信息(AllowSaleList)表服务接口
 *
 * <p>可购清单是确定人货关系的唯一凭证
 *
 * <p>主要属性businessCode+listType+productCode
 *
 * <p>productCode确定货
 *
 * <p>businessCode+listType确定人
 *
 * <p>businessCode 根据业务不同可以是终端、客户、用户等
 *
 * <p>listType 为业务区分，和businessCode业务匹配
 *
 * @author sunx
 * @date 2021-11-19 15:15:42
 */
public interface AllowSaleListService {

  /**
   * 分页条件查询
   *
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<AllowSaleList> findByConditions(Pageable pageable, AllowSaleListPaginationDto dto);

  /**
   * 逻辑删除
   *
   * @param ids 主键集合
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 获取可购商品编码集合(验证商品是否可购)
   *
   * @param dto 验证可购商品请求dto
   * @return
   */
  List<String> findAllowSaleProductCodes(ValidateAllowSaleProductDto dto);

  // ==========================上面的是历史接口===============================================

  /**
   * 根据传入的itemKeys新增数据，1、删除历史数据落库新数据，2、查询关联数据组装最终结果数据
   *
   * @param itemKeys 行记录编码
   */
  void createByItemKeys(Set<String> itemKeys);

  /**
   * 根据可购规则创建清单数据
   *
   * @param rule 关联规则
   * @param list 清单数据
   */
  void createByRule(RelateRule rule, List<AllowSaleList> list);

  /**
   * 增量刷新清单数据（只操作增量的，不更新历史数据）
   *
   * @param saleList 清单数据
   */
  void saveByList(List<AllowSaleList> saleList);

  /**
   * 同步关联清单数据的可购、不可购规则偏移量数据
   *
   * @param rule 关联规则
   * @param offset 偏移量
   */
  void updateAllowNumByRule(RelateRule rule, Integer offset);

  /** 清理作废的清单数据（allow=0&&not_allow=0） */
  void cleanListData();
}
