package com.biz.crm.dms.business.allow.sale.local.list.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.allow.sale.local.list.service.AllowSaleListService;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListDmsPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListDmsVoService;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListDmsVo;
import com.biz.crm.mdm.business.product.spu.sdk.dto.AllowSaleListSpuPaginationDto;
import com.biz.crm.mdm.business.product.spu.sdk.service.AllowSaleListSpuVoService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.AllowSaleListSpuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 可购清单电商首页分页查询相关接口实现
 *
 * @author sunx
 * @date 2021/12/6
 */
@Service
public class AllowSaleListDmsVoServiceImpl implements AllowSaleListDmsVoService {

  @Autowired(required = false)
  private AllowSaleListSpuVoService allowSaleListSpuVoService;

  @Autowired(required = false)
  private AllowSaleListService allowSaleListService;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 模糊搜索
   *
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<AllowSaleListDmsVo> findByConditions(
      Pageable pageable, AllowSaleListDmsPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 10));
    dto = Optional.ofNullable(dto).orElse(new AllowSaleListDmsPaginationDto());

    ValidateAllowSaleProductDto validateAllowSaleProductDto = new ValidateAllowSaleProductDto();
    validateAllowSaleProductDto.setListType(dto.getListType());
    validateAllowSaleProductDto.setBusinessCode(dto.getBusinessCode());
    List<String> allowSaleProductCodes =
        allowSaleListService.findAllowSaleProductCodes(validateAllowSaleProductDto);
    if (CollectionUtils.isEmpty(allowSaleProductCodes)) {
      return null;
    }

    AllowSaleListSpuPaginationDto allowSaleListSpuPaginationDto =
        new AllowSaleListSpuPaginationDto();
    allowSaleListSpuPaginationDto.setBusinessCode(dto.getBusinessCode());
    allowSaleListSpuPaginationDto.setListType(dto.getListType());
    allowSaleListSpuPaginationDto.setPageSize(pageable.getPageSize());
    allowSaleListSpuPaginationDto.setPage(pageable.getPageNumber());
    allowSaleListSpuPaginationDto.setKeyword(dto.getKeyword());
    allowSaleListSpuPaginationDto.setProductCodeList(allowSaleProductCodes);
    allowSaleListSpuPaginationDto.setProductLevelCode(dto.getProductLevelCode());
    allowSaleListSpuPaginationDto.setSpuTagList(dto.getSpuTagList());

    Page<AllowSaleListSpuVo> page =
        allowSaleListSpuVoService.onRequestByAllowSaleListSpuPaginationDto(
            allowSaleListSpuPaginationDto);
    if (Objects.isNull(page)) {
      return null;
    }
    Page<AllowSaleListDmsVo> pageResult = new Page<>();
    pageResult.setTotal(page.getTotal());
    page.setSize(page.getSize());

    if (CollectionUtils.isNotEmpty(page.getRecords())) {
      Map<String, List<BigDecimal>> map =
          page.getRecords().stream()
              .filter(
                  a ->
                      StringUtils.isNoneBlank(a.getSpuCode())
                          && !CollectionUtils.isEmpty(a.getPriceShowList()))
              .collect(
                  Collectors.toMap(
                      AllowSaleListSpuVo::getSpuCode,
                      AllowSaleListSpuVo::getPriceShowList,
                      (a, b) -> a));
      List<AllowSaleListDmsVo> records =
          (List<AllowSaleListDmsVo>)
              this.nebulaToolkitService.copyCollectionByBlankList(
                  page.getRecords(),
                  AllowSaleListSpuVo.class,
                  AllowSaleListDmsVo.class,
                  HashSet.class,
                  ArrayList.class,
                  "priceShowList");
      for (AllowSaleListDmsVo item : records) {
        item.setPriceShowList(map.get(item.getSpuCode()));
      }
      pageResult.setRecords(records);
      pageResult.setCurrent(pageable.getPageNumber());
    }
    return pageResult;
  }

  /**
   * 非模糊搜索
   *
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<AllowSaleListDmsVo> findByConditionsPrecise(
      Pageable pageable, AllowSaleListDmsPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 10));
    dto = Optional.ofNullable(dto).orElse(new AllowSaleListDmsPaginationDto());

    ValidateAllowSaleProductDto validateAllowSaleProductDto = new ValidateAllowSaleProductDto();
    validateAllowSaleProductDto.setListType(dto.getListType());
    validateAllowSaleProductDto.setBusinessCode(dto.getBusinessCode());
    List<String> allowSaleProductCodes =
        allowSaleListService.findAllowSaleProductCodes(validateAllowSaleProductDto);
    if (CollectionUtils.isEmpty(allowSaleProductCodes)) {
      return null;
    }

    AllowSaleListSpuPaginationDto allowSaleListSpuPaginationDto =
        new AllowSaleListSpuPaginationDto();
    allowSaleListSpuPaginationDto.setBusinessCode(dto.getBusinessCode());
    allowSaleListSpuPaginationDto.setListType(dto.getListType());
    allowSaleListSpuPaginationDto.setPageSize(pageable.getPageSize());
    allowSaleListSpuPaginationDto.setPage(pageable.getPageNumber());
    allowSaleListSpuPaginationDto.setKeyword(dto.getKeyword());
    allowSaleListSpuPaginationDto.setProductCodeList(allowSaleProductCodes);
    allowSaleListSpuPaginationDto.setProductLevelCode(dto.getProductLevelCode());
    allowSaleListSpuPaginationDto.setSpuTagList(dto.getSpuTagList());

    Page<AllowSaleListSpuVo> page =
        allowSaleListSpuVoService.onRequestByAllowSaleListSpuPrecisePaginationDto(
            allowSaleListSpuPaginationDto);
    if (Objects.isNull(page)) {
      return null;
    }
    Page<AllowSaleListDmsVo> pageResult = new Page<>();
    pageResult.setTotal(page.getTotal());
    page.setSize(page.getSize());

    if (CollectionUtils.isNotEmpty(page.getRecords())) {
      Map<String, List<BigDecimal>> map =
          page.getRecords().stream()
              .filter(
                  a ->
                      StringUtils.isNoneBlank(a.getSpuCode())
                          && !CollectionUtils.isEmpty(a.getPriceShowList()))
              .collect(
                  Collectors.toMap(
                      AllowSaleListSpuVo::getSpuCode,
                      AllowSaleListSpuVo::getPriceShowList,
                      (a, b) -> a));
      List<AllowSaleListDmsVo> records =
          (List<AllowSaleListDmsVo>)
              this.nebulaToolkitService.copyCollectionByBlankList(
                  page.getRecords(),
                  AllowSaleListSpuVo.class,
                  AllowSaleListDmsVo.class,
                  HashSet.class,
                  ArrayList.class,
                  "priceShowList");
      for (AllowSaleListDmsVo item : records) {
        item.setPriceShowList(map.get(item.getSpuCode()));
      }
      pageResult.setRecords(records);
      pageResult.setCurrent(pageable.getPageNumber());
    }
    return pageResult;
  }
}
