package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleBusinessTrigger;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalEventDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 终端事件实现
 *
 * @author sunx
 * @date 2022/5/25
 */
@Component
public class AllowTerminalEventListenerImpl implements TerminalEventListener {

  @Autowired(required = false)
  private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

  @Override
  @Transactional
  public void onApproved(TerminalEventDto dto) {
    Validate.notNull(dto, "终端参数不能为空");
    final TerminalVo vo = dto.getNewest();
    Validate.notNull(vo, "终端参数不能为空");
    vo.setProcessStatus(ActApproveStatusEnum.APPROVED.getCode());
    final String terminalCode = vo.getTerminalCode();
    if (StringUtils.isBlank(terminalCode)) {
      return;
    }
    this.handlerAllowSale(vo, Boolean.TRUE);
  }

  @Override
  @Transactional
  public void onUpdate(TerminalEventDto dto) {
    Validate.notNull(dto, "终端参数不能为空");
    final TerminalVo oldVo = dto.getOriginal();
    final TerminalVo vo = dto.getNewest();
    Validate.notNull(vo, "终端参数不能为空");
    final List<TerminalRelaOrgVo> oldOrgList = oldVo.getOrgList();
    final List<TerminalRelaOrgVo> orgList = vo.getOrgList();
    Set<String> oldOrgCodeSet = Sets.newHashSet();
    Set<String> orgCodeSet = Sets.newHashSet();
    if (!CollectionUtils.isEmpty(oldOrgList)) {
      oldOrgCodeSet =
          oldOrgList.stream()
              .filter(a -> StringUtils.isNotBlank(a.getOrgCode()))
              .map(TerminalRelaOrgVo::getOrgCode)
              .collect(Collectors.toSet());
    }
    if (!CollectionUtils.isEmpty(orgList)) {
      orgCodeSet =
          orgList.stream()
              .filter(a -> StringUtils.isNotBlank(a.getOrgCode()))
              .map(TerminalRelaOrgVo::getOrgCode)
              .collect(Collectors.toSet());
    }
    // 需要删除的清单信息
    final SetView<String> d1 = Sets.difference(oldOrgCodeSet, orgCodeSet);
    // 需要新增的清单信息
    final SetView<String> d2 = Sets.difference(orgCodeSet, oldOrgCodeSet);
    if (!ActApproveStatusEnum.APPROVED.getCode().equals(vo.getProcessStatus())
        || (d1.isEmpty() && d2.isEmpty())) {
      return;
    }
    if (!d1.isEmpty()) {
      List<TerminalRelaOrgVo> curOrgList = Lists.newLinkedList();
      for (String item : d1) {
        final TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
        cur.setOrgCode(item);
        curOrgList.add(cur);
      }
      oldVo.setOrgList(curOrgList);
      this.handlerAllowSale(oldVo, Boolean.FALSE);
    }

    if (!d2.isEmpty()) {
      List<TerminalRelaOrgVo> curOrgList = Lists.newLinkedList();
      for (String item : d2) {
        final TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
        cur.setOrgCode(item);
        curOrgList.add(cur);
      }
      vo.setOrgList(curOrgList);
      this.handlerAllowSale(vo, Boolean.TRUE);
    }
  }

  @Override
  @Transactional
  public void onDelete(TerminalEventDto dto) {
    Validate.notNull(dto, "终端审核参数不能为空");
    final TerminalVo original = dto.getOriginal();
    Validate.notNull(original, "终端审核参数不能为空");
    if (!ActApproveStatusEnum.APPROVED.getCode().equals(original.getProcessStatus())) {
      return;
    }
    this.handlerAllowSale(original, Boolean.FALSE);
  }

  /**
   * 根据终端信息操作可购信息
   *
   * @param vo
   * @param createFlag
   */
  private void handlerAllowSale(TerminalVo vo, Boolean createFlag) {
    if (Objects.isNull(vo) || StringUtils.isBlank(vo.getTerminalCode())) {
      return;
    }
    final String terminalCode = vo.getTerminalCode();
    final List<TerminalRelaOrgVo> orgList = vo.getOrgList();
    Set<String> orgCodeSet = Sets.newHashSet();
    if (!CollectionUtils.isEmpty(orgList)) {
      orgCodeSet =
          orgList.stream()
              .filter(a -> StringUtils.isNotBlank(a.getOrgCode()))
              .map(TerminalRelaOrgVo::getOrgCode)
              .collect(Collectors.toSet());
    }
    if (CollectionUtils.isEmpty(orgCodeSet)) {
      final AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
      business.setBusinessCode(terminalCode);
      business.setDimensionType(AllowSaleDimensionTypeEnums.TERMINAL.getCode());
      if (Boolean.TRUE.equals(createFlag)) {
        this.allowSaleRuleListAdapter.createByBusiness(business);
      } else {
        this.allowSaleRuleListAdapter.deleteByBusiness(business);
      }
    } else {
      for (String orgCode : orgCodeSet) {
        final AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
        business.setBusinessCode(terminalCode);
        business.setDimensionType(AllowSaleDimensionTypeEnums.TERMINAL.getCode());
        business.setRelateTypeCode(orgCode);
        business.setRelateDimensionType(AllowSaleDimensionTypeEnums.TERMINAL_ORG.getCode());
        if (Boolean.TRUE.equals(createFlag)) {
          this.allowSaleRuleListAdapter.createByBusiness(business);
        } else {
          this.allowSaleRuleListAdapter.deleteByBusiness(business);
        }
      }
    }
  }
}
