package com.biz.crm.dms.business.allow.sale.local.list.service.notifier;

import com.biz.crm.dms.business.allow.sale.local.list.model.AllowSaleRuleBusinessTrigger;
import com.biz.crm.dms.business.allow.sale.local.rule.service.internal.AllowSaleRuleListAdapter;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleDimensionTypeEnums;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalRelateOrgEventDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalRelateOrgEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.workflow.sdk.constant.enums.ActApproveStatusEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * 终端重新绑定组织事件实现
 *
 * @author sunx
 * @date 2022/5/26
 */
@Component
public class AllowTerminalRelateOrgEventListenerImpl implements TerminalRelateOrgEventListener {

  @Autowired(required = false)
  private AllowSaleRuleListAdapter allowSaleRuleListAdapter;

  @Override
  @Transactional
  public void onRebind(TerminalRelateOrgEventDto dto) {
    Validate.notNull(dto, "终端参数不能为空");
    final TerminalVo vo = dto.getTerminalVo();
    Validate.notNull(dto, "终端参数不能为空");
    final String oldOrgCode = Optional.ofNullable(dto.getOldOrgCode()).orElse(StringUtils.EMPTY);
    final String orgCode = Optional.ofNullable(dto.getNewOrgCode()).orElse(StringUtils.EMPTY);
    if (!ActApproveStatusEnum.APPROVED.getCode().equals(vo.getProcessStatus())
        || oldOrgCode.equals(orgCode)) {
      return;
    }
    if (StringUtils.isNotBlank(oldOrgCode)) {
      final TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
      cur.setOrgCode(oldOrgCode);
      List<TerminalRelaOrgVo> orgList = Lists.newArrayList(cur);
      vo.setOrgList(orgList);
      this.handlerAllowSale(vo, Boolean.FALSE);
    }
    if (StringUtils.isNotBlank(orgCode)) {
      final TerminalRelaOrgVo cur = new TerminalRelaOrgVo();
      cur.setOrgCode(orgCode);
      List<TerminalRelaOrgVo> orgList = Lists.newArrayList(cur);
      vo.setOrgList(orgList);
      this.handlerAllowSale(vo, Boolean.TRUE);
    }
  }

  /**
   * 根据终端信息操作可购信息
   *
   * @param vo
   * @param createFlag
   */
  private void handlerAllowSale(TerminalVo vo, Boolean createFlag) {
    if (Objects.isNull(vo) || StringUtils.isBlank(vo.getTerminalCode())) {
      return;
    }
    final String terminalCode = vo.getTerminalCode();
    final List<TerminalRelaOrgVo> orgList = vo.getOrgList();
    Set<String> orgCodeSet = Sets.newHashSet();
    if (!CollectionUtils.isEmpty(orgList)) {
      orgCodeSet =
          orgList.stream()
              .filter(a -> StringUtils.isNotBlank(a.getOrgCode()))
              .map(TerminalRelaOrgVo::getOrgCode)
              .collect(Collectors.toSet());
    }
    if (CollectionUtils.isEmpty(orgCodeSet)) {
      final AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
      business.setBusinessCode(terminalCode);
      business.setDimensionType(AllowSaleDimensionTypeEnums.TERMINAL.getCode());
      if (Boolean.TRUE.equals(createFlag)) {
        this.allowSaleRuleListAdapter.createByBusiness(business);
      } else {
        this.allowSaleRuleListAdapter.deleteByBusiness(business);
      }
    } else {
      for (String orgCode : orgCodeSet) {
        final AllowSaleRuleBusinessTrigger business = new AllowSaleRuleBusinessTrigger();
        business.setBusinessCode(terminalCode);
        business.setDimensionType(AllowSaleDimensionTypeEnums.TERMINAL.getCode());
        business.setRelateTypeCode(orgCode);
        business.setRelateDimensionType(AllowSaleDimensionTypeEnums.TERMINAL_ORG.getCode());
        if (Boolean.TRUE.equals(createFlag)) {
          this.allowSaleRuleListAdapter.createByBusiness(business);
        } else {
          this.allowSaleRuleListAdapter.deleteByBusiness(business);
        }
      }
    }
  }
}
