package com.biz.crm.dms.business.allow.sale.local.product.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 允销规则关联的可购商品信息(AllowSaleRuleProduct)实体类
 *
 * @author sunx
 * @since 2021-11-19 15:17:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_allow_sale_rule_product")
@Table(
    name = "dms_allow_sale_rule_product",
    indexes = {
      @Index(name = "dasrp_idx1", columnList = "rule_code"),
      @Index(name = "dasrp_idx2", columnList = "relate_code"),
    })
@ApiModel(value = "AllowSaleRuleProduct", description = "允销规则关联的可购商品信息")
@org.hibernate.annotations.Table(
    appliesTo = "dms_allow_sale_rule_product",
    comment = "允销规则关联的可购商品信息")
public class AllowSaleRuleProduct extends TenantEntity {

  /** 允销规则编码 */
  @ApiModelProperty("允销规则编码")
  @TableField(value = "rule_code")
  @Column(name = "rule_code", length = 64, columnDefinition = "varchar(64) COMMENT '允销规则编码'")
  private String ruleCode;

  /** 关联类型，商品spu或产品层级 */
  @ApiModelProperty("关联类型，商品spu或产品层级,AllowSaleRuleProductRelateTypeEnums,[spu,product_level,product]")
  @TableField(value = "relate_type")
  @Column(
      name = "relate_type",
      length = 36,
      columnDefinition = "varchar(36) COMMENT '关联类型，商品spu或产品层级'")
  private String relateType;

  /** spu编码或商品层级编码 */
  @ApiModelProperty("spu编码或商品层级编码")
  @TableField(value = "relate_code")
  @Column(
      name = "relate_code",
      length = 64,
      columnDefinition = "varchar(64) COMMENT 'spu编码或商品层级编码'")
  private String relateCode;

  /** spu名称或商品层级名称 */
  @ApiModelProperty("spu名称或商品层级名称")
  @TableField(exist = false)
  @Transient
  private String relateName;

  /**
   * 行记录重复key
   *
   * @return
   */
  public String getItemCode() {
    return this.relateType + "-" + this.relateCode;
  }
}
