package com.biz.crm.dms.business.allow.sale.local.product.service;

import com.biz.crm.dms.business.allow.sale.local.product.entity.AllowSaleRuleProduct;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 允销规则关联的可购商品信息(AllowSaleRuleProduct)表服务接口
 *
 * @author sunx
 * @date 2021-11-19 15:17:33
 */
public interface AllowSaleRuleProductService {

  /**
   * 根据规则编码获取关联集合信息
   *
   * @param ruleCode 规则编码
   * @return
   */
  List<AllowSaleRuleProduct> findByRuleCode(String ruleCode);

  /**
   * 批量保存关联信息
   *
   * @param list 清单数据
   */
  void batchSave(List<AllowSaleRuleProduct> list);

  /**
   * 获取规则编码绑定的可购商品sku编码集合map
   *
   * @param ruleCodeList 规则编码
   * @return k-规则编码，v-商品编码集合
   */
  Map<String, Set<String>> findRuleRelateProductCodesMapByRuleCodes(List<String> ruleCodeList);

  /**
   * 获取商品层级匹配的规则编码集合map,找到层级及其上级配置的规则信息
   *
   * @param productLevelCodeList 商品层级编码
   * @return k-产品层级编码，v-规则编码集合
   */
  Map<String, Set<String>> findProductLevelRelateRuleCodesMapByProductLevelCodes(
      List<String> productLevelCodeList);

  /**
   * 获取spu匹配的规则编码集合map
   *
   * @param spuCodeList spu编码
   * @return k-spu编码，v-规则编码集合
   */
  Map<String, Set<String>> findSpuRelateRuleCodesMapBySpuCodes(List<String> spuCodeList);

  /**
   * 获取sku匹配的规则编码集合map
   *
   * @param productCodeList 商品编码
   * @return k-sku编码，v-规则编码集合
   */
  Map<String, Set<String>> findSkuRelateRuleCodesMapBySkuCodes(List<String> productCodeList);
}
