package com.biz.crm.dms.business.order.config.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import com.biz.crm.dms.business.order.config.sdk.service.OrderValidateVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 订单配置管理: OrderValidateVo: 订单配置
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Slf4j
@RestController
@RequestMapping("/v1/orderConfig/orderConfig")
@Api(tags = "订单配置: OrderValidateVo: 订单配置信息")
public class OrderValidateVoController {

  @Autowired(required = false)
  private OrderValidateVoService orderValidateVoService;

  /**
   * 根据优先级规则获取订单配置信息
   *
   * @param orderType 订单类型
   * @param customerCode 客户编码
   * @return 订单配置
   */
  @ApiOperation(value = "根据优先级规则获取订单配置信息")
  @GetMapping("/findByOrderTypeAndCustomerCode")
  public Result<OrderConfigVo> findByOrderTypeAndCustomerCode(@RequestParam(value = "orderType") @ApiParam(name = "orderType", value = "订单类型", required = true) String orderType,
                                                              @RequestParam(value = "customerCode") @ApiParam(name = "customerCode", value = "客户编码", required = true) String customerCode) {
    try {
      return Result.ok(this.orderValidateVoService.findByOrderTypeAndCustomerCode(orderType, customerCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
