package com.biz.crm.dms.business.order.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 订单配置生效维度实体类
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Getter
@Setter
@ApiModel(value = "OrderConfigDimensionEntity", description = "订单配置生效维度实体类")
@Entity
@TableName("dms_order_config_dimension")
@Table(name = "dms_order_config_dimension",
    indexes = {@Index(columnList = "tenant_code , order_type, config_code, type, code", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_order_config_dimension", comment = "订单配置生效维度实体类")
public class OrderConfigDimensionEntity extends TenantEntity {
  private static final long serialVersionUID = -5179020074058541758L;

  /**
   * 订单配置编码
   */
  @ApiModelProperty("订单配置编码")
  @Column(name = "config_code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单配置编码'")
  private String configCode;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  @Column(name = "order_type", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '订单类型'")
  private String orderType;

  /**
   * 类型：customer（客户）；org（组织）
   */
  @ApiModelProperty("类型：customer（客户）；org（组织）")
  @Column(name = "type", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '类型：customer（客户）；org（组织）'")
  private String type;

  /**
   * 编码：type=customer时表示客户；type=org时表示组织
   */
  @ApiModelProperty("编码：type=customer时表示客户；type=org时表示组织")
  @Column(name = "code", columnDefinition = "VARCHAR(64) NOT NULL COMMENT '编码：type=customer时表示客户；type=org时表示组织'")
  private String code;
}
