package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Lists;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

/**
 * @description: 订单货补要素注册实现
 * @author: rentao
 * @date: 2022/1/15 13:42
 */
@Service
@Slf4j
public class CompensatedGoodsElementRegisterImpl implements OrderStatisticsElementRegister {

  @Override
  public String getOrderStatisticsElementCode() {
    return OrderStatisticsElementConstant.COMPENSATED_GOODS;
  }


  @Override
  public String getOrderStatisticsElementName() {
    return "货补";
  }

  @Override
  public BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext) {
    Validate.notNull(orderVerificationContext, "货补统计金额时:订单数据为空");
    OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
    Validate.notNull(orderTabulateDto, "货补统计金额时:订单分摊计算后的vo为空");
    List<OrderDetailTabulateDto> orderDetails = orderTabulateDto.getOrderDetails();
    Validate.isTrue(!CollectionUtils.isEmpty(orderDetails), "货补统计金额时:订单明细为空");
    BigDecimal reduce = orderDetails.stream()
        .filter(orderDetailTabulateDto -> ItemTypeEnum.COMPENSATED_GOODS.getDictCode()
            .equals(orderDetailTabulateDto.getItemType()) &&
            Objects.nonNull(orderDetailTabulateDto.getSalesAmount())
        ).map(OrderDetailTabulateDto::getSalesAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    return reduce;
  }

  @Override
  public BigDecimal getFeeQuantity(List<OrderDetailDto> products) {
    return Optional.of(products).orElse(Lists.newArrayList()).stream()
        .map(OrderDetailDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
  }
}
