package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Lists;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

/**
 * @description: 订单折扣要素注册实现
 * @author: rentao
 * @date: 2022/1/15 13:42
 */
@Service
@Slf4j
public class DiscountGoodsElementRegisterImpl implements OrderStatisticsElementRegister {

  @Autowired(required = false)
  @Qualifier("DiscountApportionTallyItemRegister")
  private TallyItemRegister tallyItemRegister;

  @Override
  public String getOrderStatisticsElementCode() {
    return OrderStatisticsElementConstant.DISCOUNT_GOODS;
  }

  @Override
  public String getOrderStatisticsElementName() {
    return "折扣";
  }

  @Override
  public BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext) {
    Validate.notNull(orderVerificationContext, "折扣统计金额时:订单数据为空");
    OrderDto orderDto = orderVerificationContext.getOrderDto();
    Validate.notNull(orderDto, "折扣统计金额时:订单分摊计算后的vo为空");
    List<OrderPayDto> orderPays = orderDto.getOrderPays();
    Validate.isTrue(!CollectionUtils.isEmpty(orderPays), "折扣统计金额时:订单明细为空");
    Validate.notNull(tallyItemRegister, "折扣费用池分摊注册器获取失败！");
    String itemKey = tallyItemRegister.findTallyItemRegisterModel().getItemKey();
    BigDecimal reduce = orderPays.stream()
        .filter(orderPayDto -> itemKey.equals(orderPayDto.getItemKey()) &&
            Objects.nonNull(orderPayDto.getItemAmount())
        ).map(OrderPayDto::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    return reduce;
  }

  @Override
  public BigDecimal getFeeQuantity(List<OrderDetailDto> products) {
    return Optional.of(products).orElse(Lists.newArrayList()).stream()
        .map(OrderDetailDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
  }
}
