package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import java.math.BigDecimal;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

/**
 * @description: 费用池默认
 * @author: rentao
 * @date: 2022/1/18 18:24
 */
@Service
@Slf4j
public class FeePoolDefaultElementRegisterImpl implements OrderStatisticsElementRegister {

  @Override
  public String getOrderStatisticsElementCode() {
    return OrderStatisticsElementConstant.FEE_POOL_DEFAULT_ELEMENT;
  }

  @Override
  public String getOrderStatisticsElementName() {
    return "费用池默认";
  }

  /**
   * 订单总金额-政策优惠金额
   *
   * @param orderVerificationContext
   * @author rentao
   * @date
   */
  @Override
  public BigDecimal getFeeMoney(OrderVerificationContext orderVerificationContext) {
    Validate.notNull(orderVerificationContext, "费用池默认统计金额时:订单数据为空");
    OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
    Validate.notNull(orderTabulateDto, "费用池默认统计金额时:订单分摊计算后的vo为空");
    BigDecimal policyDiscountAmount =
        Objects.isNull(orderTabulateDto.getPolicyDiscountAmount()) ? BigDecimal.ZERO
            : orderTabulateDto.getPolicyDiscountAmount();
    BigDecimal totalOrderAmount =
        Objects.isNull(orderTabulateDto.getTotalOrderAmount()) ? BigDecimal.ZERO
            : orderTabulateDto.getTotalOrderAmount();
    BigDecimal subtract = totalOrderAmount.subtract(policyDiscountAmount);
    return subtract;
  }
}
