package com.biz.crm.dms.business.order.statistics.element.local.service.register;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.constant.OrderStatisticsElementConstant;
import com.biz.crm.dms.business.order.feerate.fee.statistics.sdk.register.OrderStatisticsElementRegister;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

/**
 * @description: 订单政策要素注册实现
 * @author: rentao
 * @date: 2022/1/15 13:43
 */
@Service
@Slf4j
public class FreeElementRegisterImpl implements OrderStatisticsElementRegister {

  @Override
  public String getOrderStatisticsElementCode() {
    return OrderStatisticsElementConstant.FREE_GOODS;
  }

  @Override
  public String getOrderStatisticsElementName() {
    return "免费";
  }

  @Override
  public BigDecimal getFeeQuantity(List<OrderDetailDto> products) {
    return Optional.of(products).orElse(Lists.newArrayList()).stream().map(OrderDetailDto::getQuantity).reduce(BigDecimal.ZERO,BigDecimal::add);
  }
}
