/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.policy.standard.fullminus.executestrategy;

import com.biz.crm.dms.business.policy.local.context.UnitpriceCycleExecuteContext;
import com.biz.crm.dms.business.policy.local.cyclestrategy.AccumulationCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.MultipleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.cyclestrategy.SingleCycleRuleStrategy;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.service.SalePolicyExecutorService;
import com.biz.crm.dms.business.policy.local.sharestrategy.UnitpriceShareStrategyWithAmountAndNumber;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorLadderVo;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyExecutorVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceCycleStepResult;
import com.biz.crm.dms.business.policy.sdk.context.UnitpriceProduct;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCycleRuleStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteShareStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.biz.crm.dms.business.policy.standard.fullminus.executestrategy.AbstractFullminusUnitpriceExecuteStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class ProductFullminusUnitpriceCountExecuteStrategy
extends AbstractFullminusUnitpriceExecuteStrategy {
    @Autowired(required=false)
    private SalePolicyExecutorService salePolicyExecutorService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public String getExecuteStrategyCode() {
        return "productFullminusUnitpriceCountExecuteStrategy";
    }

    public String getExecuteStrategyDesc() {
        return "\u6ee1\u6570\u91cf\u4eab\u5355\u4ef7\u6ee1\u51cf";
    }

    public String getExpression() {
        return "\u672c\u5355\u4e2d\u672c\u54c1\u6570\u91cf\u8d2d\u4e70\u6ee1{integer:input-integer:fullCountValue}\u9500\u552e\u5355\u4f4d\uff0c\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf{decimal:input-random:priceValue}\u5143";
    }

    public Class<SalePolicyExecutorVo> getSalePolicyExecutorInfoClass() {
        return SalePolicyExecutorVo.class;
    }

    public String getCycleRuleExample(String cycleRuleCode) {
        if (StringUtils.equals((CharSequence)cycleRuleCode, (CharSequence)"single")) {
            return "\u4f8b\u5982\uff1a\u6ee11000\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf3\u5143\uff0c\u6ee1500\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf1\u5143\u3002\u90a3\u4e48\u672c\u54c1\u9500\u552e\u6570\u91cf\u4e3a1300\u5355\u4f4d\u65f6\uff0c\u5219\u603b\u4ef7\u6700\u591a\u53ef\u4f18\u60e03900\u5143 ";
        }
        if (StringUtils.equals((CharSequence)cycleRuleCode, (CharSequence)"multiple")) {
            return "\u4f8b\u5982\uff1a\u6ee11000\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf3\u5143\uff0c\u6ee1500\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf1\u5143\u3002\u90a3\u4e48\u672c\u54c1\u9500\u552e\u6570\u91cf\u4e3a1300\u5355\u4f4d\u65f6\uff0c\u5219\u603b\u4ef7\u6700\u591a\u53ef\u4f18\u60e03900\u5143\uff08\u56e0\u4eab\u53d71000\u9500\u552e\u5355\u4f4d\u533a\u95f4\u6ee1\u51cf\u540e\uff0c\u5269\u4f59\u672a\u4eab\u53d7\u4f18\u60e0\u7684\u6570\u91cf\u5df2\u4e0d\u8db3500\uff09";
        }
        if (StringUtils.equals((CharSequence)cycleRuleCode, (CharSequence)"accumulation")) {
            return "\u4f8b\u5982\uff1a\u6ee11000\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf3\u5143\uff0c\u6ee1500\u9500\u552e\u5355\u4f4d\u5404\u672c\u54c1\u5355\u4ef7\u6700\u591a\u51cf1\u5143\u3002\u90a3\u4e48\u672c\u54c1\u9500\u552e\u6570\u91cf\u4e3a2600\u5355\u4f4d\u65f6\uff0c\u5219\u603b\u4ef7\u6700\u591a\u53ef\u4f18\u60e07800 + 7800 + 2600 = 18200\u5143";
        }
        return "";
    }

    public Class<? extends SalePolicyExecuteShareStrategy> getSalePolicyExecuteShareStrategy() {
        return UnitpriceShareStrategyWithAmountAndNumber.class;
    }

    public Collection<Class<? extends SalePolicyCycleRuleStrategy>> getCycleRuleStrategyClasses() {
        return Lists.newArrayList((Object[])new Class[]{SingleCycleRuleStrategy.class, MultipleCycleRuleStrategy.class, AccumulationCycleRuleStrategy.class});
    }

    public List<SalePolicyExecutorVo> onRequestSalePolicyExecutorInfo(String tenantCode, String salePolicyCode) {
        List salePolicyExecutors = this.salePolicyExecutorService.findBySalePolicyCodeAndTenantCode(salePolicyCode, tenantCode, this.getExecuteStrategyCode());
        if (CollectionUtils.isEmpty((Collection)salePolicyExecutors)) {
            return null;
        }
        Collection salePolicyExecutorVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)salePolicyExecutors, SalePolicyExecutor.class, SalePolicyExecutorVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"salePolicyExecutorLadders", "salePolicyExecutorLadders.executorLadderVars"});
        return Lists.newArrayList((Iterable)salePolicyExecutorVos);
    }

    @Transactional
    public void onSaveSalePolicyExecutorInfo(boolean update, SalePolicyVo currentSalePolicy, SalePolicyVo oldSalePolicy) {
        this.handleSaveSalePolicyExecutorInfo(update, currentSalePolicy, oldSalePolicy, currentSalePolicy.getSalePolicyExecutorInfos().stream().map(item -> (SalePolicyExecutorVo)item).collect(Collectors.toSet()));
        super.validatetExpressionParams(currentSalePolicy);
    }

    public AbstractCycleExecuteContext buildCycleExecuteContext(AbstractPolicyExecuteContext abstractExecuteContext, String executorCode, Set<SalePolicyConProduct> initPolicyProducts, String customerCode) {
        return super.buildFullminusUnitpriceCycleExecuteContext(executorCode, abstractExecuteContext, initPolicyProducts, customerCode);
    }

    public boolean execute(AbstractCycleExecuteContext abstractCycleExecuteContext, int index, int times, Map<String, Object> varParams, SalePolicyExecutorLadderVo salePolicyExecutorLadder) {
        UnitpriceCycleExecuteContext cycleExecuteContext = (UnitpriceCycleExecuteContext)abstractCycleExecuteContext;
        UnitpriceCycleStepResult lastCycleStepResult = cycleExecuteContext.findLastStepResult();
        Integer preSurplusSubtotalNumber = lastCycleStepResult.getLastSurplusSubtotalNumber();
        Object fullCountValueObject = varParams.get("fullCountValue");
        Object priceValueObject = varParams.get("priceValue");
        if (fullCountValueObject == null || priceValueObject == null) {
            return false;
        }
        Integer fullCountValue = (Integer)fullCountValueObject;
        BigDecimal priceValue = (BigDecimal)priceValueObject;
        if (fullCountValue > preSurplusSubtotalNumber) {
            return false;
        }
        BigDecimal preSubtotalAmount = lastCycleStepResult.getLastSubtotalAmount();
        BigDecimal preSurplusSubtotalAmount = lastCycleStepResult.getLastSurplusSubtotalAmount();
        Set preProducts = lastCycleStepResult.getLastProducts();
        UnitpriceCycleStepResult newFullminusUnitpriceCycleStepResult = new UnitpriceCycleStepResult(index, times, preSubtotalAmount, preSurplusSubtotalAmount, preSurplusSubtotalNumber, preProducts);
        BigDecimal newCycleAmountResult = BigDecimal.ZERO;
        LinkedHashSet lastProducts = Sets.newLinkedHashSet();
        for (UnitpriceProduct preFullminusUnitpriceProduct : preProducts) {
            String productCode = preFullminusUnitpriceProduct.getProductCode();
            BigDecimal prePrices = preFullminusUnitpriceProduct.getPrices();
            Integer productNumber = preFullminusUnitpriceProduct.getNumbers();
            BigDecimal lastPrices = prePrices.subtract(priceValue).setScale(4, RoundingMode.HALF_UP);
            if (lastPrices.compareTo(BigDecimal.ZERO) == -1) {
                lastPrices = BigDecimal.ZERO;
                newCycleAmountResult = newCycleAmountResult.add(BigDecimal.ZERO);
            } else {
                newCycleAmountResult = newCycleAmountResult.add(priceValue.multiply(new BigDecimal(productNumber)).setScale(4, RoundingMode.HALF_UP));
            }
            UnitpriceProduct lastFullminusUnitpriceProduct = new UnitpriceProduct(productCode, productNumber, lastPrices);
            lastProducts.add(lastFullminusUnitpriceProduct);
        }
        BigDecimal result = preSubtotalAmount.subtract(newCycleAmountResult).setScale(4, RoundingMode.HALF_UP);
        newFullminusUnitpriceCycleStepResult.setLastSubtotalAmount(result);
        newFullminusUnitpriceCycleStepResult.setLastSurplusSubtotalAmount(result);
        newFullminusUnitpriceCycleStepResult.setLastSurplusSubtotalNumber(Integer.valueOf(preSurplusSubtotalNumber - fullCountValue));
        newFullminusUnitpriceCycleStepResult.setLastProducts((Set)lastProducts);
        cycleExecuteContext.addStepResult(newFullminusUnitpriceCycleStepResult);
        return true;
    }
}

