/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.jdb.file.local.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.jdb.file.local.entity.TbAttachmentEntity;
import com.biz.crm.common.jdb.file.local.repository.TbAttachmentRepository;
import com.biz.crm.common.jdb.file.sdk.service.TbAttachmentService;
import com.biz.crm.common.jdb.file.sdk.vo.TbAttachmentVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.vo.UuidVo;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TbAttachmentServiceImpl
implements TbAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(TbAttachmentServiceImpl.class);
    @Autowired(required=false)
    private TbAttachmentRepository tbAttachmentRepository;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public List<TbAttachmentVo> findFileList(String businessKey) {
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return Collections.emptyList();
        }
        return this.tbAttachmentRepository.findFileList(Collections.singletonList(businessKey), null);
    }

    public List<TbAttachmentVo> findFileList(String businessKey, String attachmentType) {
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            return Collections.emptyList();
        }
        return this.tbAttachmentRepository.findFileList(Collections.singletonList(businessKey), attachmentType);
    }

    public List<TbAttachmentVo> findFileList(List<String> businessKeys) {
        if (CollectionUtils.isEmpty(businessKeys)) {
            return Collections.emptyList();
        }
        return this.tbAttachmentRepository.findFileList(businessKeys, null);
    }

    public List<TbAttachmentVo> findFileList(List<String> businessKeys, String attachmentType) {
        if (CollectionUtils.isEmpty(businessKeys)) {
            return Collections.emptyList();
        }
        return this.tbAttachmentRepository.findFileList(businessKeys, attachmentType);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveFile(String fileCode, String businessKey) {
        this.saveFile(fileCode, businessKey, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveFile(String fileCode, String businessKey, String attachmentType) {
        Assert.hasLength((String)fileCode, (String)"\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)businessKey, (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        this.saveFile(Collections.singletonList(fileCode), businessKey, attachmentType);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveFile(List<String> fileCodes, String businessKey) {
        this.saveFile(fileCodes, businessKey, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveFile(List<String> fileCodes, String businessKey, String attachmentType) {
        Assert.notEmpty(fileCodes, (String)"\u6587\u4ef6id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasLength((String)businessKey, (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList attachmentEntityList = new ArrayList();
        fileCodes.forEach(item -> Assert.hasLength((String)item, (String)"\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a"));
        List files = this.fileHandleService.findByIds(fileCodes);
        Assert.notEmpty((Collection)files, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        Assert.isTrue((files.size() == fileCodes.size() ? 1 : 0) != 0, (String)"\u6587\u4ef6id\u6570\u91cf\u4e0e\u5b9e\u9645\u6587\u4ef6\u6570\u91cf\u4e0d\u4e00\u81f4");
        FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String postId = loginUserDetails.getPostId();
        files.forEach(file -> {
            TbAttachmentEntity attachment = new TbAttachmentEntity();
            attachment.setAttachmentType(attachmentType);
            attachment.setPositionId(postId);
            attachment.setBusinessKey(businessKey);
            String attachmentTitle = file.getOriginalFileName();
            if (StringUtils.isNotBlank((CharSequence)attachmentTitle)) {
                attachmentTitle = attachmentTitle.replace(".".concat(file.getPrefix()), "");
            }
            attachment.setAttachmentTitle(attachmentTitle);
            attachment.setRealPath(file.getRelativeLocal());
            attachment.setExtend(file.getPrefix());
            attachment.setFileCode(file.getId());
            attachment.setFileVersion("3.0");
            attachmentEntityList.add(attachment);
        });
        this.tbAttachmentRepository.saveBatch(attachmentEntityList);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TbAttachmentVo> saveOrUpdateBatch(List<TbAttachmentVo> files) {
        Assert.notEmpty(files, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        files.forEach(file -> {
            Assert.hasLength((String)file.getBusinessKey(), (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasLength((String)file.getFileCode(), (String)"\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
            file.setFileVersion("3.0");
        });
        List fileCodes = files.stream().map(TbAttachmentVo::getFileCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        List fileVos = this.fileHandleService.findByIds(fileCodes);
        Map<String, OrdinaryFileVo> fileVoMap = fileVos.stream().collect(Collectors.toMap(UuidVo::getId, item -> item));
        Collection entityList = this.nebulaToolkitService.copyCollectionByBlankList(files, TbAttachmentVo.class, TbAttachmentEntity.class, HashSet.class, ArrayList.class, new String[0]);
        entityList.forEach(file -> {
            OrdinaryFileVo fileVo = (OrdinaryFileVo)fileVoMap.get(file.getFileCode());
            if (Objects.nonNull(fileVo)) {
                String attachmentTitle = fileVo.getFileName();
                if (StringUtils.isNotBlank((CharSequence)attachmentTitle)) {
                    attachmentTitle = attachmentTitle.replace(".".concat(fileVo.getPrefix()), "");
                }
                file.setAttachmentTitle(attachmentTitle);
                file.setRealPath(fileVo.getRelativeLocal());
                file.setExtend(fileVo.getPrefix());
            }
            file.setUpdateInfoToNull();
        });
        this.tbAttachmentRepository.saveOrUpdateBatch(entityList);
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityList, TbAttachmentEntity.class, TbAttachmentVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delByBusinessKey(String businessKey) {
        Assert.hasLength((String)businessKey, (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        this.delByBusinessKey(Collections.singletonList(businessKey));
    }

    @Transactional(rollbackFor={Exception.class})
    public void delByBusinessKey(List<String> businessKeys) {
        Assert.notEmpty(businessKeys, (String)"\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        List<TbAttachmentEntity> files = this.tbAttachmentRepository.findByBusinessKeys(businessKeys);
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        this.tbAttachmentRepository.removeByIds(files.stream().map(UuidEntity::getId).collect(Collectors.toList()));
        this.fileHandleService.deleteFile(files.stream().map(TbAttachmentEntity::getFileCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList()));
    }

    @Transactional(rollbackFor={Exception.class})
    public void delByFileCode(String fileCode) {
        Assert.hasLength((String)fileCode, (String)"\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        this.delByFileCode(Collections.singletonList(fileCode));
    }

    @Transactional(rollbackFor={Exception.class})
    public void delByFileCode(List<String> fileCodes) {
        Assert.notEmpty(fileCodes, (String)"\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(TbAttachmentEntity::getFileCode, fileCodes);
        this.tbAttachmentRepository.remove((Wrapper)wrapper);
        this.fileHandleService.deleteFile(fileCodes);
    }
}

