package com.biz.crm.common.jdb.file.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidCrmOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 附件父表(其他附件表需继承该表).
 * <p>
 *
 * @author liukai
 * @version v1.0
 */

@Entity
@Data
@TableName("tb_attachment")
@Table(name = "tb_attachment", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "tb_attachment", comment = "附件实体类")
public class TbAttachmentEntity extends UuidCrmOpEntity {


    private static final long serialVersionUID = -7315047915447518923L;
    @ApiModelProperty(value = "创建职位")
    @Column(name = "position_id")
    @TableField(value = "position_id")
    private String positionId;

    @ApiModelProperty(value = "业务类主键")
    @Column(name = "business_key")
    @TableField(value = "business_key")
    private String businessKey;

    @ApiModelProperty(value = "子类名称全路径")
    @Column(name = "subclass_name")
    @TableField(value = "subclass_name")
    private String subclassName;

    @ApiModelProperty(value = "附件名称")
    @Column(name = "attachment_title")
    @TableField(value = "attachment_title")
    private String attachmentTitle;

    @ApiModelProperty(value = "附件内容")
    @Column(name = "attachment_content")
    @TableField(value = "attachment_content")
    private byte[] attachmentContent;

    @ApiModelProperty(value = "附件物理路径")
    @Column(name = "real_path")
    @TableField(value = "real_path")
    private String realPath;

    @ApiModelProperty(value = "备注")
    @Column(name = "note")
    @TableField(value = "note")
    private String note;

    @ApiModelProperty(value = "swf格式路径")
    @Column(name = "swf_path")
    @TableField(value = "swf_path")
    private String swfPath;

    @ApiModelProperty(value = "扩展名")
    @Column(name = "extend")
    @TableField(value = "extend")
    private String extend;

    @ApiModelProperty(value = "附件类型")
    @Column(name = "attachment_type")
    @TableField(value = "attachment_type")
    private String attachmentType;

    @ApiModelProperty(value = "id")
    @Column(name = "communicate_id")
    @TableField(value = "communicate_id")
    private String communicateId;

    @ApiModelProperty(value = "文件编码")
    @TableField(value = "file_code")
    @Column(name = "file_code", columnDefinition = "VARCHAR2(64)")
    private String fileCode;

    @ApiModelProperty(value = "文件版本")
    @TableField(value = "file_version")
    @Column(name = "file_version", columnDefinition = "VARCHAR2(4)")
    private String fileVersion;


}
