package com.biz.crm.common.jdb.file.local.repository;


import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.constant.CommonConstant;
import com.biz.crm.common.jdb.file.local.entity.TbAttachmentEntity;
import com.biz.crm.common.jdb.file.local.mapper.TbAttachmentMapper;
import com.biz.crm.common.jdb.file.sdk.vo.TbAttachmentVo;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户表(repository)
 *
 * @author xi.peng
 * @since 2021-11-04 16:47:02
 */
@Component
public class TbAttachmentRepository extends ServiceImpl<TbAttachmentMapper, TbAttachmentEntity> {


    public List<TbAttachmentVo> findFileList(List<String> businessKeys, String attachmentType) {
        if (CollectionUtils.isEmpty(businessKeys)) {
            return Lists.newArrayList();
        }
        businessKeys = businessKeys.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(businessKeys)) {
            return Lists.newArrayList();
        }
        List<TbAttachmentVo> files = Lists.newArrayList();
        Lists.partition(businessKeys, CommonConstant.ORACLE_MAX_IN).forEach(list -> {
            files.addAll(this.baseMapper.findFileList(list, attachmentType));
        });
        return files;
    }

    public List<TbAttachmentEntity> findByBusinessKeys(List<String> businessKeys) {
        if (CollectionUtils.isEmpty(businessKeys)) {
            return Lists.newArrayList();
        }
        businessKeys = businessKeys.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(businessKeys)) {
            return Lists.newArrayList();
        }
        List<TbAttachmentEntity> files = Lists.newArrayList();
        Lists.partition(businessKeys, CommonConstant.ORACLE_MAX_IN).forEach(list -> files.addAll(
                this.lambdaQuery()
                        .in(TbAttachmentEntity::getBusinessKey, list).list()));
        return files;
    }

    public List<TbAttachmentEntity> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ids = ids.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<TbAttachmentEntity> files = Lists.newArrayList();
        Lists.partition(ids, CommonConstant.ORACLE_MAX_IN).forEach(list -> files.addAll(
                this.lambdaQuery()
                        .in(TbAttachmentEntity::getId, list).list()));
        return files;
    }
}
