package com.biz.crm.common.jdb.file.sdk.service;


import com.biz.crm.common.jdb.file.sdk.vo.TbAttachmentVo;

import java.util.List;

/**
 * 附件管理 Service.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
public interface TbAttachmentService {


    /**
     * 根据业务key查询该业务的附件列表.
     * <p>
     * sql查询使用IN businessKey是一个值是直接传值无变化<p>
     * 当值是多个时,第一个值前面的 ' 和最后一个只 后面的 ' 不用拼接<p>
     *
     * @param businessKey 业务键，用于标识业务对象
     * @return 返回符合条件的附件列表
     */
    List<TbAttachmentVo> findFileList(String businessKey);


    /**
     * 根据业务key查询该业务的附件列表.
     * <p>
     * sql查询使用IN businessKey是一个值是直接传值无变化<p>
     * 当值是多个时,第一个值前面的 ' 和最后一个只 后面的 ' 不用拼接<p>
     *
     * @param businessKey    业务键，用于标识业务对象
     * @param attachmentType 附件类型，用于过滤附件
     * @return 返回符合条件的附件列表
     */
    List<TbAttachmentVo> findFileList(String businessKey, String attachmentType);

    /**
     * 根据业务key查询该业务的附件列表.
     * <p>
     * sql查询使用IN businessKey是一个值是直接传值无变化<p>
     * 当值是多个时,第一个值前面的 ' 和最后一个只 后面的 ' 不用拼接<p>
     *
     * @param businessKeys 业务键，用于标识业务对象
     * @return 返回符合条件的附件列表
     */
    List<TbAttachmentVo> findFileList(List<String> businessKeys);


    /**
     * 根据业务key查询该业务的附件列表.
     * <p>
     * sql查询使用IN businessKey是一个值是直接传值无变化<p>
     * 当值是多个时,第一个值前面的 ' 和最后一个只 后面的 ' 不用拼接<p>
     *
     * @param businessKeys   业务键，用于标识业务对象
     * @param attachmentType 附件类型，用于过滤附件
     * @return 返回符合条件的附件列表
     */
    List<TbAttachmentVo> findFileList(List<String> businessKeys, String attachmentType);


    /**
     * 准备添加附件
     *
     * @param fileCode    venus 文件ID
     * @param businessKey 业务ID
     */
    void saveFile(String fileCode, String businessKey);
    void saveFile(String fileCode, String businessKey,String attachmentType);

    /**
     * @param fileCodes    venus 文件ID
     * @param businessKey 业务ID
     */
    void saveFile(List<String> fileCodes, String businessKey);
    void saveFile(List<String> fileCodes, String businessKey,String attachmentType);

    List<TbAttachmentVo> saveOrUpdateBatch(List<TbAttachmentVo> files);

    /**
     * 根据业务键列表批量删除附件
     *
     * @param businessKeys 业务ID
     */
    void delByBusinessKey(List<String> businessKeys);

    /**
     * 根据文件代码和ID删除附件
     *
     * @param businessKey 业务ID
     */
    void delByBusinessKey(String businessKey);

    /**
     * 根据文件代码列表批量删除附件
     *
     * @param fileCode venus 文件ID
     */
    void delByFileCode(String fileCode);

    /**
     * 根据文件代码列表批量删除附件
     *
     * @param fileCodes venus 文件ID
     */
    void delByFileCode(List<String> fileCodes);
}
