package com.biz.crm.common.jdb.file.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidCrmOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 附件管理Vo 对象.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "附件管理Vo")
public class TbAttachmentVo extends UuidCrmOpVo {
    private static final long serialVersionUID = -484754201458363965L;
    @ApiModelProperty("岗位ID")
    private String positionId;
    @ApiModelProperty("业务类主键")
    private String businessKey;
    @ApiModelProperty("子类名称全路径")
    private String subclassName;
    @ApiModelProperty("附件名称")
    private String attachmentTitle;
    @ApiModelProperty("附件物理路径")
    private String realPath;
    @ApiModelProperty("笔记")
    private String note;
    @ApiModelProperty("swf格式路径")
    private String swfPath;
    @ApiModelProperty("扩展名")
    private String extend;
    @ApiModelProperty("附件类型，对应数据字典attachment_type 值")
    private String attachmentType;
    @ApiModelProperty("trueAnswer")
    private String trueAnswer;
    @ApiModelProperty("url")
    private String url;
    @ApiModelProperty("文件编码")
    private String fileCode;
    @ApiModelProperty("文件版本")
    private String fileVersion;
}
