/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.business.invoice.order.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.direct.store.sdk.vo.DirectStoreVo;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderEntity;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGoodsEntity;
import com.biz.crm.kms.business.invoice.order.local.entity.OrderGrabEntity;
import com.biz.crm.kms.business.invoice.order.local.model.OrderConditionModel;
import com.biz.crm.kms.business.invoice.order.local.model.OrderGrabSyncModel;
import com.biz.crm.kms.business.invoice.order.local.repository.OrderRepository;
import com.biz.crm.kms.business.invoice.order.local.service.OrderGoodsService;
import com.biz.crm.kms.business.invoice.order.local.service.OrderGrabService;
import com.biz.crm.kms.business.invoice.order.local.service.OrderService;
import com.biz.crm.kms.business.invoice.order.sdk.dto.OrderPageDto;
import com.biz.crm.kms.business.invoice.order.sdk.enums.OrderStatus;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="orderService")
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired
    private OrderRepository orderRepository;
    @Autowired
    private OrderGoodsService orderGoodsService;
    @Autowired
    private OrderGrabService orderGrabService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public OrderEntity transform(OrderEntity entity, OrderGrabSyncModel syncModel) {
        OrderEntity orderEntity = this.orderRepository.findByOrderNumber(entity.getTenantCode(), entity.getOrderNumber());
        if (Objects.nonNull((Object)orderEntity) && BooleanEnum.FALSE.getCapital().equals(orderEntity.getTransFlag())) {
            return orderEntity;
        }
        this.clearTransformInfo(entity);
        this.buildOrderInfo(entity, syncModel);
        this.orderGoodsService.transform(entity, syncModel);
        this.buildOrderStatus(entity);
        if (Objects.nonNull((Object)orderEntity)) {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)orderEntity));
        } else {
            orderEntity = entity;
        }
        this.orderRepository.saveOrUpdate((Object)orderEntity);
        return entity;
    }

    @Override
    public void clearTransformInfo(OrderEntity entity) {
        entity.setSoldToPartyName(null);
        entity.setSoldToPartyCode(null);
        entity.setStoreCode(null);
        entity.setStoreName(null);
        entity.setAreaCode(null);
        entity.setAreaName(null);
    }

    @Override
    public void buildOrderStatus(OrderEntity entity) {
        List goodsErrorList = entity.getGoodsList().stream().filter(orderGoodsEntity -> Objects.equals(orderGoodsEntity.getOrderStatus(), OrderStatus.S100.getDictCode())).map(OrderGoodsEntity::getOrderStatusMsg).collect(Collectors.toList());
        if (Objects.equals(entity.getOrderStatus(), OrderStatus.S200.getDictCode())) {
            if (CollectionUtils.isEmpty(goodsErrorList)) {
                entity.setOrderStatusMsg("\u8f6c\u6362\u6210\u529f");
            } else {
                entity.setOrderStatus(OrderStatus.S100.getDictCode());
                entity.setOrderStatusMsg("\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e");
            }
        } else if (!CollectionUtils.isEmpty(goodsErrorList)) {
            entity.setOrderStatusMsg(String.format("%s|%s", entity.getOrderStatusMsg(), "\u5546\u54c1\u884c\u4fe1\u606f\u5b58\u5728\u8f6c\u6362\u5931\u8d25\u6570\u636e"));
        }
    }

    @Override
    @Transactional
    public void manualTrans(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        OrderConditionModel model = new OrderConditionModel();
        model.setIds(Sets.newHashSet(ids));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<OrderEntity> entities = this.orderRepository.findByOrderConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u8f6c\u6362\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> Validate.isTrue((boolean)Lists.newArrayList((Object[])new String[]{OrderStatus.S200.getDictCode(), OrderStatus.S101.getDictCode(), OrderStatus.S100.getDictCode()}).contains(entity.getOrderStatus()), (String)String.format("\u8ba2\u8d27\u5355[%s]\u5df2\u786e\u8ba4,\u65e0\u6cd5\u7ee7\u7eed\u5339\u914d", entity.getOrderNumber()), (Object[])new Object[0]));
        List orderGrabEntities = (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, OrderEntity.class, OrderGrabEntity.class, HashSet.class, ArrayList.class, new String[0]);
        OrderGrabSyncModel syncModel = this.orderGrabService.buildOrderGrabSyncModel(orderGrabEntities);
        entities.forEach(entity -> {
            entity.setOrderStatusMsg(null);
            this.transform((OrderEntity)((Object)entity), syncModel);
        });
    }

    @Override
    @Transactional
    public void create(List<OrderEntity> orderEntities) {
        if (CollectionUtils.isEmpty(orderEntities)) {
            return;
        }
        List splitEntities = Lists.partition(orderEntities, (int)2000);
        splitEntities.forEach(entities -> this.orderRepository.saveBatch((Collection)entities));
    }

    @Override
    public List<OrderEntity> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        OrderConditionModel model = new OrderConditionModel();
        model.setIds(ids);
        model.setTenantCode(TenantUtils.getTenantCode());
        return this.orderRepository.findByOrderConditionModel(model);
    }

    @Override
    @Transactional
    public void confirm(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        OrderConditionModel model = new OrderConditionModel();
        model.setIds(Sets.newHashSet(ids));
        model.setTenantCode(TenantUtils.getTenantCode());
        List<OrderEntity> entities = this.orderRepository.findByOrderConditionModel(model);
        Validate.isTrue((!CollectionUtils.isEmpty(entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u786e\u8ba4\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        entities.forEach(entity -> {
            Validate.isTrue((boolean)OrderStatus.S200.getDictCode().equals(entity.getOrderStatus()), (String)String.format("\u8ba2\u8d27\u5355[%s]\u975e\u5f85\u786e\u8ba4\u72b6\u6001,\u65e0\u6cd5\u786e\u8ba4", entity.getOrderNumber()), (Object[])new Object[0]);
            entity.setOrderStatus(OrderStatus.S300.getDictCode());
            entity.setOrderStatusMsg(OrderStatus.S300.getValue());
            entity.setTransFlag(BooleanEnum.FALSE.getCapital());
        });
        this.orderRepository.updateBatchById(entities);
    }

    @Override
    public Page<OrderEntity> findByConditions(Pageable pageable, OrderPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        dto = (OrderPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new OrderPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return this.orderRepository.findByConditions(pageable, dto);
    }

    @Override
    public void buildOrderInfo(OrderEntity entity, OrderGrabSyncModel syncModel) {
        entity.setOrderStatus(OrderStatus.S100.getDictCode());
        entity.setTransFlag(BooleanEnum.TRUE.getCapital());
        if (StringUtils.isBlank((CharSequence)entity.getKaStoreCode())) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        List<DirectStoreVo> directStoreList = syncModel.getDirectStoreMap().get(String.format("%s-%s", entity.getDirectCode(), entity.getKaStoreCode()));
        if (CollectionUtils.isEmpty(directStoreList)) {
            entity.setOrderStatusMsg("\u672a\u67e5\u8be2\u5230\u4e0e\u4f01\u4e1a\u95e8\u5e97\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        if (directStoreList.size() > 1) {
            entity.setOrderStatusMsg("\u5546\u8d85\u95e8\u5e97\u5b58\u5728\u591a\u4e2a\u5bf9\u5e94\u5173\u7cfb");
            return;
        }
        DirectStoreVo directStoreVo = directStoreList.get(0);
        entity.setKaCode(directStoreVo.getSupermarketCode());
        entity.setKaName(directStoreVo.getSupermarketName());
        entity.setStoreCode(directStoreVo.getTerminalCode());
        entity.setStoreName(directStoreVo.getTerminalName());
        entity.setAreaCode(directStoreVo.getSupermarketAreaCode());
        entity.setAreaName(directStoreVo.getSupermarketAreaName());
        List<Object> terminalSupplyList = syncModel.getTerminalSupplyMap().get(entity.getStoreCode());
        if (!CollectionUtils.isEmpty(terminalSupplyList)) {
            terminalSupplyList = terminalSupplyList.stream().filter(terminalSupplyVo -> StringUtils.isNotBlank((CharSequence)terminalSupplyVo.getCustomerCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(terminalSupplyList)) {
            entity.setOrderStatusMsg("\u672a\u5339\u914d\u552e\u8fbe\u65b9\u4fe1\u606f");
            return;
        }
        if (terminalSupplyList.size() > 1) {
            entity.setOrderStatusMsg(String.format("\u7ec8\u7aef\u95e8\u5e97[%s]\u627e\u5230\u591a\u4e2a\u552e\u8fbe\u65b9", entity.getStoreCode()));
            return;
        }
        TerminalSupplyVo terminalSupplyVo2 = (TerminalSupplyVo)terminalSupplyList.get(0);
        entity.setSoldToPartyCode(terminalSupplyVo2.getCustomerCode());
        entity.setSoldToPartyName(terminalSupplyVo2.getCustomerName());
        entity.setOrderStatus(OrderStatus.S200.getDictCode());
    }
}

