package com.biz.crm.kms.business.supermarket.parameter.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.kms.business.invoice.sdk.constant.InvoiceConstant;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterPageDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.service.SupermarketParameterVoService;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商超抓单参数表(SupermarketParameter)表控制层
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:58
 */
@Slf4j
@Api(tags = "商超抓单参数：SupermarketParameterVo")
@RestController
@RequestMapping(value = {"/v1/supermarketParameter/supermarketParameterVo"})
public class SupermarketParameterVoController {

  @Autowired(required = false)
  private SupermarketParameterVoService supermarketParameterVoService;

  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<SupermarketParameterVo>> findByConditions(@PageableDefault(50) Pageable pageable, SupermarketParameterPageDto dto) {
    try {
      Page<SupermarketParameterVo> result = this.supermarketParameterVoService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "条件查询列表")
  @GetMapping(value = {"/findListByConditions"})
  public Result<List<SupermarketParameterVo>> findListByConditions(SupermarketParameterDto dto) {
    try {
      List<SupermarketParameterVo> result = this.supermarketParameterVoService.findListByConditions(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "条件查询列表（包含登录参数）")
  @GetMapping(value = {"/findListByConditionsIncludeLogin"})
  public Result<List<SupermarketParameterVo>> findListByConditionsIncludeLogin(SupermarketParameterDto dto) {
    try {
      List<String> interfaceParameters = new ArrayList<>();
      interfaceParameters.add(InvoiceConstant.LOGIN_ORDER_TYPE);
      interfaceParameters.add(dto.getInterfaceParameter());
      dto.setInterfaceParameters(interfaceParameters);
      dto.setInterfaceParameter(null);
      List<SupermarketParameterVo> result = this.supermarketParameterVoService.findListByConditions(dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<SupermarketParameterVo> findDetailById(@RequestParam("id") String id) {
    try {
      SupermarketParameterVo vo = this.supermarketParameterVoService.findDetailById(id);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result create(@RequestBody SupermarketParameterDto dto) {
    try {
      this.supermarketParameterVoService.create(dto);
      return Result.ok("创建成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result update(@RequestBody SupermarketParameterDto dto) {
    try {
      this.supermarketParameterVoService.update(dto);
      return Result.ok("更新成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.supermarketParameterVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.supermarketParameterVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.supermarketParameterVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
