package com.biz.crm.kms.business.supermarket.parameter.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 抓单请求参数表(SupermarketParameter)实体类
 *
 * @author sunx
 * @since 2022-09-23 10:47:57
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "kms_supermarket_parameter")
@TableName(value = "kms_supermarket_parameter")
@ApiModel(value = "SupermarketParameter", description = "商超抓单参数表")
@org.hibernate.annotations.Table(appliesTo = "kms_supermarket_parameter", comment = "商超抓单参数表")
public class SupermarketParameterEntity extends TenantFlagOpEntity {

  @ApiModelProperty("商超编码")
  @TableField(value = "supermarket_code")
  @Column(name = "supermarket_code", length = 32, columnDefinition = "varchar(32) COMMENT '商超编码'")
  private String supermarketCode;

  @ApiModelProperty("接口参数")
  @TableField(value = "interface_parameter")
  @Column(name = "interface_parameter", length = 32, columnDefinition = "varchar(32) COMMENT '接口参数'")
  private String interfaceParameter;

  @ApiModelProperty("控件类型（INPUT：单行文本，SELECT：下拉单选，CHECKBOX：下拉多选，DATERANGE：日期范围，DATE：日期单选）")
  @TableField(value = "control_type")
  @Column(name = "control_type", length = 32, columnDefinition = "varchar(32) COMMENT '控件类型（INPUT：单行文本，SELECT：下拉单选，CHECKBOX：下拉多选，DATERANGE：日期范围，DATE：日期单选）'")
  private String controlType;

  @ApiModelProperty("参数属性")
  @TableField(value = "parameter_attr")
  @Column(name = "parameter_attr", length = 32, columnDefinition = "varchar(32) COMMENT '参数属性'")
  private String parameterAttr;

  @ApiModelProperty("参数文本")
  @TableField(value = "parameter_text")
  @Column(name = "parameter_text", length = 64, columnDefinition = "varchar(64) COMMENT '参数文本'")
  private String parameterText;

  @ApiModelProperty("提示文本")
  @TableField(value = "prompt_text")
  @Column(name = "prompt_text", length = 256, columnDefinition = "varchar(256) COMMENT '提示文本'")
  private String promptText;

  @ApiModelProperty("是否显示（0：否，1：是）")
  @TableField(value = "is_show")
  @Column(name = "is_show", length = 8, columnDefinition = "varchar(8) COMMENT '是否显示（0：否，1：是）'")
  private String isShow;

  @ApiModelProperty("是否必填（0：否，1：是）")
  @TableField(value = "is_required")
  @Column(name = "is_required", length = 8, columnDefinition = "varchar(8) COMMENT '是否必填（0：否，1：是）'")
  private String isRequired;

}
