package com.biz.crm.kms.business.supermarket.parameter.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商超抓单参数表附属标签表(SupermarketParameterLabel)实体类
 *
 * @author pengxi
 * @since 2022-09-23 10:49:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "kms_supermarket_parameter_label")
@TableName(value = "kms_supermarket_parameter_label")
@ApiModel(value = "SupermarketParameterLabel", description = "商超抓单参数表附属标签表")
@org.hibernate.annotations.Table(appliesTo = "kms_supermarket_parameter_label", comment = "商超抓单参数表附属标签表")
public class SupermarketParameterLabelEntity extends UuidEntity {

  @ApiModelProperty("参数表ID")
  @TableField(value = "parameter_id")
  @Column(name = "parameter_id", length = 256, columnDefinition = "varchar(256) COMMENT '参数表ID'")
  private String parameterId;

  @ApiModelProperty("标签名称")
  @TableField(value = "name_label")
  @Column(name = "name_label", length = 64, columnDefinition = "varchar(64) COMMENT '标签名称'")
  private String nameLabel;

  @ApiModelProperty("标签值")
  @TableField(value = "value_label")
  @Column(name = "value_label", length = 64, columnDefinition = "varchar(64) COMMENT '标签值'")
  private String valueLabel;

  @ApiModelProperty("排序")
  @TableField(value = "sort_index")
  @Column(name = "sort_index", length = -1, columnDefinition = "int COMMENT '排序'")
  private Integer sortIndex;

}
